import { StyleSheet } from "react-native";
import dpr from "../../../../../../Utilities/CustomStyleAttribute/dpr";

const VariationContentStyle = (value, selectedItemValue) =>
    StyleSheet.create({
        variationCont: {
            paddingHorizontal: dpr(20),
            width: dpr("wf") - dpr(110),
            flex: 1,
            marginBottom: dpr(80),
        },
        headerIcon: {
            position: "absolute",
            right: dpr(-105),
            width: dpr(40),
            height: dpr(40),
            borderRadius: 50,
            flexDirection: "row",
            justifyContent: "center",
            alignItems: "center",
            zIndex: 9999
        },
        iconRipple: { color: 'gray', radius: 20 },
        headerCont: {
            flexDirection: "row",
            marginVertical: dpr(24),
        },
        image: {
            height: dpr(90),
            width: dpr(90),
            marginRight: dpr(12),
            borderRadius: 4,
            backgroundColor: "#F3F3F3",
        },
        name: {
            width: dpr("wf") - dpr(160),
            fontFamily: "DMSans_500Medium",
            fontSize: dpr(14),
            color: "#2C2C2C",
            marginBottom: dpr(6),
            textAlign: 'left'
        },
        stockCont: {
            marginBottom: dpr(20),
            marginTop: dpr(-20),
        },
        variationTitle: {
            fontFamily: "DMSans_500Medium",
            fontSize: dpr(17),
            lineHeight: dpr(20),
            color: "#2C2C2C",
            textAlign: 'left',
        },
        variationValueCont: {
            flexDirection: "row",
            flexWrap: "wrap",
            marginTop: dpr(12),
            marginBottom: dpr(24),
        },
        variationValueText: {
            marginRight: dpr(12),
            marginBottom: dpr(12),
            borderWidth: 1,
            borderColor: value == selectedItemValue ? "#FCCA19" : "#898989",
            backgroundColor: value == selectedItemValue ? "#FCCA19" : "#FFFFFF",
            paddingHorizontal: dpr(16),
            paddingVertical: dpr(10),
            borderRadius: 4,
            fontFamily: "Roboto_500Medium",
        },
        typeVariable: {
            position: "absolute",
            bottom: dpr(10),
        },
        clearVariationInner: {
            flexDirection: "row",
            alignItems: "center",
            gap: dpr(5),
            alignSelf: "flex-start",
        },
        clearVariation: {
            backgroundColor: "#FFFFFF",
            paddingHorizontal: dpr(20),
            paddingVertical: dpr(5),
        }
    });

export default VariationContentStyle;
